// NODE-ELEMENTE.
Object.defineProperties(Node.prototype, {
  'insertAfter': {
      value: function(node) {
        this.parentNode.insertBefore(node,this.nextSibling);
      },
      writable:false,
      enumerable:false,
      configurable:false
  },
  'removeClass': {
    value: function(c) {
      str = this.className;
      str = str.split(' ');
      str.forEach(function(element,idx,array) {
        if (element === c) {
          array.splice(idx,1);
        }
      });
      this.className = str.join(' ');
      return this;
    },
    writable:false,
    enumerable:false,
    configurable:false
  },
  'aufklappen': {
    value: function() {
      if(this.hasAttribute('aria-expanded')) {
        this.ariaExpanded = true;
        if(this.parentNode) {this.parentNode.aufklappen()};
      }
    },
    writable:false,
    enumerable:false,
    configurable:false
  },
  'documentOffsetTop': {
    value: function() {
      var y = 0;
      y = this.offsetTop;
      if(this.offsetParent) {y += this.offsetParent.documentOffsetTop()};
      return y;
    },
    writable:false,
    enumerable:false,
    configurable:false
  },
  'scrollIntoViewCenter': {
    value: function() {
      var y = this.documentOffsetTop()-window.innerHeight/2;
      if(y>0) {window.scrollTo(0,y)};
    },
    writable:false,
    enumerable:false,
    configurable:false
  },
});

// NODELIST-ELEMENTE.
Object.defineProperties(NodeList.prototype, {
  'cloneNodeList': {
    value: function() {
      var list = [];
      for(var i=0; i<this.length; i++) {
        list.push(this[i].cloneNode(true));
      }
      return list;
    },
    writable:false,
    enumerable:false,
    configurable:false
  }
});

// STRING-ELEMENTE.
Object.defineProperties(String.prototype, {
  'toRegExp': {
    value: function() {
      return this.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, '\\$&');
    },
    writable:false,
    enumerable:false,
    configurable:false
  },
  'getMatches': {
    value: function(regex_muster) {
      tokens = [];
      this.replace(regex_muster,function(match,token) {
        tokens.push(token);
      });
      return tokens;
    },
    writable:false,
    enumerable:false,
    configurable:false
  },
  'removeOuterbraces': {
    value: function(str) {
      str = this;
      regex=[];
      ['[]','()','{}'].forEach(function(element) {
        var r = new RegExp('^'+'\\'+element[0]+'(.*?)'+'\\'+element[1]+'$');
        regex.push(r);
      });
      cond = true;
      while(cond) {
        cond = false;
        regex.forEach(function(element) {
          if(element.test(str)) {
            cond = true;
            str = str.replace(element,function(match,tok) {return tok;});
          }
        });
      }
      return str;
    },
    writable:false,
    enumerable:false,
    configurable:false
  },
  'stripHTTPWWW': {
    value: function() {
      var url = this;
      var regex = new RegExp(/^[a-zA-Z0-9]*:\/\/(.)*/);
      if(regex.test(url)) {
        url = url.getMatches(/^.*?:\/\/(.*)/);
        url = url[0].replace(/^www[\d]*\./,'');
      } else {
        url = '';
      }
      return url;
    },
    writable:false,
    enumerable:false,
    configurable:false
  },
  'getDomain': {
    value: function() {
      var url = this.stripHTTPWWW();
      url = url.getMatches(/^(.*?)(\/|$)/);
      url = url[0];
      return url;
    },
    writable:false,
    enumerable:false,
    configurable:false
  },
  'hasDomain': {
    value: function(dom) {
      var url = this.stripHTTPWWW();
      return(url.indexOf(dom)===0);
    },
    writable:false,
    enumerable:false,
    configurable:false
  },
  'parseURLparams': {
    value: function() {
      var args = Array.prototype.slice.call(arguments, 0);
      sauber = false;
      if (args.length > 0) {
        if (typeof(args[0]) === 'boolean') {
          sauber = args[0];
        }
      }
      var params = {};
      var queryStart = this.indexOf('?') + 1;
      var queryEnd = Math.max(this.indexOf('#'),this.length) + 1;
      var query = this.slice(queryStart, queryEnd - 1);
      query = query.replace(/(\w+?)\((.*?)\)/g, function(match,tok1,tok2) {
            return tok1+'='+tok2+' &';
        });
      query = query.replace(/\+/g,' ');
      var pairs = query.split('&');
      pairs.forEach(function(element,idx) {
          if(element=='') {
            pairs.splice(idx,1);
          };
      });
      for (var i = 0; i < pairs.length; i++) {
          var attribut = pairs[i].split('=', 2);
          if(attribut.length > 0) {
            if (attribut.length === 1 && i === 0) {
              var key = '?';
              var val = decodeURIComponent(attribut[0]);
            } else if (attribut.length === 2) {
              var key = decodeURIComponent(attribut[0]);
              var val = decodeURIComponent(attribut[1]);
            }
            if (sauber) {val = val.removeOuterbraces();}
            if (!params.hasOwnProperty(key)) {params[key] = [];}
            params[key].push(val);
          }
      }
      if (args.length==1) {
        if (typeof(args[0])=='string') {
          key = args[0];
          if(params.hasOwnProperty(key)) {
            params = params[key];
          } else {
            params = false;
          }
        }
      } else if (args.length==2) {
        if (typeof(args[0])=='boolean' && typeof(args[1])=='string') {
          key = args[1];
          if(params.hasOwnProperty(key)) {
            params = params[key];
          } else {
            params = false;
          }
        }
      }
      return params;
    },
    writable:false,
    enumerable:false,
    configurable:false
  },
  'invertColour': {
    value: function(typ) {
      var col = new RGBcolour(this);
      ['r','g','b'].forEach(function(element) {
        col[element] = 255-col[element];
      });
      if (typ === 'rgb') {
        col = col.toRGB();
      } else if ( typ === 'hex') {
        col = col.toHex();
      } else {
        col = col.toHex();
      }
      return col;
    },
    writable:false,
    enumerable:false,
    configurable:false
  },
});


// OBJECT-ELEMENTE.
Object.defineProperties(Object.prototype, {
  'runAttribute': {
    value: function(self,key) {
      if(this.hasOwnProperty(key)) {
        obj = this[key];
        if (obj instanceof Function) {
          var args = Array.prototype.slice.call(arguments, 2);
          obj.apply(self,args);
        }
      }
    },
    writable:false,
    enumerable:false,
    configurable:false
  },
  'showAttribute': {
    value: function(self,key) {
      if(this.hasOwnProperty(key)) {
        obj = this[key];
        if (obj instanceof Function) {
          var args = Array.prototype.slice.call(arguments, 2);
          return obj.apply(self,args);
        } else {
          return obj;
        }
      }
    },
    writable:false,
    enumerable:false,
    configurable:false
  },
  'isEqual': {
    value: function(obj) {
      var self = this;
      cond = true;
      Object.keys(self).forEach(function(key) {
        if(obj.hasOwnProperty(key)) {
          if(!(self[key] === obj[key])) {
            cond = false;
          }
        } else {
          cond = false;
        }
      });
      return cond;
    },
    writable:false,
    enumerable:false,
    configurable:false
  },
  'countUp': {
    value: function(func) {
      var self = this;
      var count = 0;
      Object.keys(self).forEach(function(key) {
        if(func(self[key])) {
          count++;
        }
      });
      return count;
    },
    writable:false,
    enumerable:false,
    configurable:false
  },
  'ausfuehren': {
    value: function(cond,action) {
      var self = this;
      Object.keys(self).forEach(function(key) {
        if(cond(self[key])) {
          self[key] = action(self[key]);
        }
      });
      return self;
    },
    writable:false,
    enumerable:false,
    configurable:false
  },
});


// ARRAY-ELEMENTE.
Object.defineProperties(Array.prototype, {
  'findeErstes': {
    value: function(func) {
        var self = this.slice(0);
        var cond = false;
        var idx = 0;
        while(!cond && idx<self.length) {
          var element = self[idx];
          if(func(element)) {
            return idx;
          }
          idx++;
        }
        return -1;
      },
    writable:false,
    enumerable:false,
    configurable:false
  },
  'getAlle': {
    value: function(func) {
        var self = this.slice(0);
        for(i=self.length-1; i>0; i--) {
          var element = self[i];
          if(!func(element)) {
            self.splice(i, 1);
          }
        }
        return self;
      },
    writable:false,
    enumerable:false,
    configurable:false
  },
  'entferneAlle': {
    value: function(func) {
        var self = this;
        for(i=self.length-1; i>0; i--) {
          var element = self[i];
          if(func(element)) {
            self.splice(i, 1);
          }
        }
      },
    writable:false,
    enumerable:false,
    configurable:false
  },
  'countUp': {
    value: function(func) {
        var self = this;
        var count = 0;
        self.forEach(function(element) {
          if(func(element)) {
            count++;
          }
        });
        return count;
      },
    writable:false,
    enumerable:false,
    configurable:false
  },
  'getAllObj': {
    value: function(obj) {
        return this.getAlle(function(element) {
          return element.isEqual(obj);
        });
      },
    writable:false,
    enumerable:false,
    configurable:false
  },
  'removeAllObj': {
    value: function(obj) {
        this.entferneAlle(function(element) {
          return element.isEqual(obj);
        });
      },
    writable:false,
    enumerable:false,
    configurable:false
  },
  'indexOfObj': {
    value: function(obj) {
        return this.findeErstes(function(element) {
          return element.isEqual(obj);
        });
      },
    writable:false,
    enumerable:false,
    configurable:false
  },
  'containsObj': {
    value: function(obj) {
        return(!(this.indexOfObj(obj) === -1));
      },
    writable:false,
    enumerable:false,
    configurable:false
  },
});